unit Unit2;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

implementation

const RuleFileName='/etc/udev/rules.d/45-stdfu-permissions.rules';

var E, VID, PID:integer;
              T:text;

begin
  if paramcount=2 then                                                 // 2 parameters --> VID and PID pair, running with elevated privileges
  try
    E:=1;                                                              // exitcode 1 --> invalid VID or PID (not a number)
    VID:=StrToInt(paramstr(1));
    PID:=StrToInt(paramstr(2));
    E:=0;                                                              // no error, CONTINUE

    writeln;
    writeln('vid = 0x', IntToHex(VID, 4), ' (0d', VID, ')');
    writeln('pid = 0x', IntToHex(PID, 4), ' (0d', PID, ')');
    writeln;

    if (VID=-1) or (PID=-1) then       // (invalid VID or PID)
    begin
      E:=2;                                                            // exitcode 2 --> unable to erase rule file
      if FileExists(RuleFileName) then
      begin
         DeleteFile(RuleFileName);                                     // delete file (if it exists)
         writeln('rule file deleted ok');
         writeln
      end;
      E:=0                                                             // no error, CONTINUE
    end

    else                               // (valid VID and PID)
    begin
      assign(T, RuleFileName);                                         // overwrite file --> only ever contains the ONE line
      E:=3;                                                            // exitcode 3 --> unable to update rule file
      rewrite(T);
      writeln(T,'SUBSYSTEM=="usb", ATTRS{idVendor}=="'+IntToHex(VID, 4)+
                               '", ATTRS{idProduct}=="'+IntToHex(PID, 4)+
                               '", MODE="0664", GROUP="plugdev"');
      close(T);
      E:=0;                                                            // no error, CONTINUE
      writeln('rule file updated ok');
      writeln
    end                                                                // (we could scan for rule, then add to end if not found)

  finally
    halt(E)                                                            // must ALWAYS halt - can not continue as a GUI when launched with 'pkexec'
  end                                                                  // (likely a bug/omission in pkexec)
end.

